/*
 * Decompiled with CFR 0.152.
 */
package de.srendi.advancedperipherals.common.addons.computercraft.owner;

import de.srendi.advancedperipherals.common.addons.computercraft.owner.IOwnerAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.OperationAbility;
import de.srendi.advancedperipherals.common.addons.computercraft.owner.PeripheralOwnerAbility;
import de.srendi.advancedperipherals.common.util.fakeplayer.APFakePlayer;
import de.srendi.advancedperipherals.lib.peripherals.IPeripheralOperation;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPeripheralOwner {
    @Nullable
    public String getCustomName();

    @Nullable
    public Level getLevel();

    @NotNull
    public BlockPos getPos();

    @NotNull
    public Direction getFacing();

    @NotNull
    public FrontAndTop getOrientation();

    @Nullable
    public Player getOwner();

    @NotNull
    public CompoundTag getDataStorage();

    public void markDataStorageDirty();

    public <T> T withPlayer(Function<APFakePlayer, T> var1);

    public ItemStack getToolInMainHand();

    public ItemStack storeItem(ItemStack var1);

    public void destroyUpgrade();

    public boolean isMovementPossible(@NotNull Level var1, @NotNull BlockPos var2);

    public boolean move(@NotNull Level var1, @NotNull BlockPos var2);

    public <T extends IOwnerAbility> void attachAbility(PeripheralOwnerAbility<T> var1, T var2);

    @Nullable
    public <T extends IOwnerAbility> T getAbility(PeripheralOwnerAbility<T> var1);

    public Collection<IOwnerAbility> getAbilities();

    default public void attachOperation(IPeripheralOperation<?> ... operations) {
        OperationAbility operationAbility = new OperationAbility(this);
        this.attachAbility(PeripheralOwnerAbility.OPERATION, operationAbility);
        for (IPeripheralOperation<?> operation : operations) {
            operationAbility.registerOperation(operation);
        }
    }

    default public void attachOperation(Collection<IPeripheralOperation<?>> operations) {
        OperationAbility operationAbility = new OperationAbility(this);
        this.attachAbility(PeripheralOwnerAbility.OPERATION, operationAbility);
        for (IPeripheralOperation<?> operation : operations) {
            operationAbility.registerOperation(operation);
        }
    }
}

